/****************************************************************************
 **                                                                        **
 **  "Oblivion" experimental raytracing engine - Aron, 1998.07.15          **
 **                                                                        **
 ****************************************************************************/

// - sajat fejlecfile-ok ----------------------------------------------------
#include "compile.h"
#include "defs.h"
#include "texture.h"
#include "tinymath.h"
#include "tracer.h"
#include "traceobj.h"
#include "scenes.h"

// - implementacio ----------------------------------------------------------
dword media;

void TraceRay(dword recursionlevel,RAY *ray,INTERSECTION *intersection,
              OMNI_LIGHTSOURCE *light,VECTOR *V,float *R,float *G,float *B)
{ dword i;
  INTERSECTION shadowintersection,reflectionintersection,refractionintersection;
  RAY shadowray,reflectedray,refractedray;
  float Rt,Gt,Bt;

  VECTOR L,Lnorm,H,S;
  float diffuse,specular;
  byte *textureptr;

  byte shadowcache= 0;

  float refract,tolerance;
  float N_dot_V,b;

  float fog_scaler,fog_adder;

  // rekurzios szint ellenorzese:
  if(recursionlevel >= MAX_RECURSION_LEVEL) { *R= *G= *B= 0.0; return; }

  // metszespontkereses:
  for(i=0; i<objects; i++) DetectObject[object[i].type](ray,&object[i],intersection,EXACT_INTERSECTION);

  // megvilagitasi modell:
  if(intersection->t != INFINITE_DISTANCE)
  { // metszespontbeli L fenyvektor:
    L.X= light->position.X - intersection->point.X;
    L.Y= light->position.Y - intersection->point.Y;
    L.Z= light->position.Z - intersection->point.Z;

    // L normaltja:
    Lnorm.X= L.X;
    Lnorm.Y= L.Y;
    Lnorm.Z= L.Z;
    NormalizeVector(&Lnorm);

    if(intersection->surfacetype & PHONG_SHADED)
    { // metszespontbeli halfway vektor V megforditasaval (H:= (L - V)/2):
      H.X= 0.5*(Lnorm.X - V->X);
      H.Y= 0.5*(Lnorm.Y - V->Y);
      H.Z= 0.5*(Lnorm.Z - V->Z);
      NormalizeVector(&H);

      // Phong ambient komponens a texturabol:
      textureptr= intersection->textureptr + ((dword)(256.0*intersection->V + intersection->U)<<2);
      *R= 0.3 * *(textureptr + 2);
      *G= 0.3 * *(textureptr + 1);
      *B= 0.3 * *(textureptr + 0);

      // Phong diffuz komponens a texturabol(diffuse:= L * N):
      diffuse= DotProductVectors(&Lnorm,&intersection->normal);
      if(diffuse > 0.0)
      { *R+= diffuse * *(textureptr + 2);
        *G+= diffuse * *(textureptr + 1);
        *B+= diffuse * *(textureptr + 0);
      }

      // Phong specular komponens (specular:= 255.0 * (H * N)^n):
      specular= DotProductVectors(&H,&intersection->normal);
      if(specular > 0.0)
      { specular= 255.0*fpow(specular,PHONG_EXPONENT);

        *R+= specular;
        *G+= specular;
        *B+= specular;
      }
    }
    else
    { // a metszespontbeli L fenyvektor hosszanak kiszamitasa:
      diffuse= (L.X*L.X + L.Y*L.Y + L.Z*L.Z)/(450.0*450.0);

      // fenyesseg a fenyforrastol valo tavolsag fuggvenyeben:
      if(diffuse < 1.0)
      { // forditott aranyossag:
        diffuse= 1.0 - diffuse;

        // vilagositott Phong diffuz komponens a texturabol:
        textureptr= intersection->textureptr + 4*(dword)(256.0*intersection->V + intersection->U);
        *R= 1.3 * diffuse * *(textureptr + 2);
        *G= 1.3 * diffuse * *(textureptr + 1);
        *B= 1.3 * diffuse * *(textureptr + 0);
      }
    }

    // fenytores:
    if(intersection->surfacetype & REFRACTIVE)
    { // fenytores indexe:
      N_dot_V= ffabs(DotProductVectors(&ray->D,&intersection->normal));

      // atlepes masik kozegbe es toresi mutato szamitasa:
      if(media == 0) refract= REFRACTION_FACTOR; else refract= 1.0/REFRACTION_FACTOR;
      media= 1 - media;

      // tort sugar kiszamitasa:
      refractionintersection.t= INFINITE_DISTANCE;
      refractedray.Pstart.X= intersection->point.X + 0.0001*ray->D.X;
      refractedray.Pstart.Y= intersection->point.Y + 0.0001*ray->D.Y;
      refractedray.Pstart.Z= intersection->point.Z + 0.0001*ray->D.Z;
      NormalizeVector(&refractedray.D);

      tolerance= 1.0 - refract*refract*(1.0 - N_dot_V*N_dot_V);

      // tores:
      b= refract*N_dot_V - fsqrt(tolerance);

      refractedray.D.X= b*intersection->normal.X + refract*ray->D.X;
      refractedray.D.Y= b*intersection->normal.Y + refract*ray->D.Y;
      refractedray.D.Z= b*intersection->normal.Z + refract*ray->D.Z;

      // tort sugar trace-elese rekurzivan (teljes atlatszosag):
      TraceRay(recursionlevel + 1,&refractedray,&refractionintersection,light,V,R,G,B);

      // metszespontbeli halfway vektor V megforditasaval (H:= (L - V)/2):
      H.X= 0.5*(Lnorm.X - V->X);
      H.Y= 0.5*(Lnorm.Y - V->Y);
      H.Z= 0.5*(Lnorm.Z - V->Z);
      NormalizeVector(&H);

      // Phong specular komponens (specular:= 255.0 * (H * N)^n):
      specular= DotProductVectors(&H,&intersection->normal);
      if(specular > 0.0)
      { specular= 255.0*fpow(specular,PHONG_EXPONENT);

        *R+= specular;
        *G+= specular;
        *B+= specular;
      }
    }

    // visszaverodes:
    if(intersection->surfacetype & REFLECTIVE)
    { // sugar tukrozese a feluleti normalisra:
      N_dot_V= -DotProductVectors(&ray->D,&intersection->normal);

      reflectionintersection.t= INFINITE_DISTANCE;
      reflectedray.Pstart.X= intersection->point.X;
      reflectedray.Pstart.Y= intersection->point.Y;
      reflectedray.Pstart.Z= intersection->point.Z;
      reflectedray.D.X= 2.0*N_dot_V*intersection->normal.X + ray->D.X;
      reflectedray.D.Y= 2.0*N_dot_V*intersection->normal.Y + ray->D.Y;
      reflectedray.D.Z= 2.0*N_dot_V*intersection->normal.Z + ray->D.Z;
      NormalizeVector(&reflectedray.D);

      // visszavert sugar trace-elese rekurzivan:
      TraceRay(recursionlevel + 1,&reflectedray,&reflectionintersection,light,V,&Rt,&Gt,&Bt);

      // uj szin az eredeti es a visszaverodott komponensekbol:
      *R= 0.4*Rt + 0.6**R;
      *G= 0.4*Gt + 0.6**G;
      *B= 0.4*Bt + 0.6**B;
    }

    // arnyekkepzes:
    if(intersection->surfacetype & SHADOWED)
    { // sugar kilovese a metszespontbol a fenyforras fele:
      shadowintersection.t= INFINITE_DISTANCE;
      shadowray.Pstart.X= intersection->point.X;
      shadowray.Pstart.Y= intersection->point.Y;
      shadowray.Pstart.Z= intersection->point.Z;
      shadowray.D.X= Lnorm.X;
      shadowray.D.Y= Lnorm.Y;
      shadowray.D.Z= Lnorm.Z;

      // blokkolasvizsgalat a shadowcache-beli object-re es tavolsagvizsgalat:
      if((&object[shadowcache] != intersection->objectptr) && (DetectObject[object[shadowcache].type](&shadowray,&object[shadowcache],&shadowintersection,EXACT_INTERSECTION)))
      { // arnyek vektor:
        S.X= shadowintersection.point.X - intersection->point.X;
        S.Y= shadowintersection.point.Y - intersection->point.Y;
        S.Z= shadowintersection.point.Z - intersection->point.Z;

        if(DotProductVectors(&L,&L) > DotProductVectors(&S,&S))
        { *R*= 0.5;
          *G*= 0.5;
          *B*= 0.5;
        }
      }
      // blokkolaskereses az elso blokkolo object-ig es tavolsagvizsgalat:
      else
      for(i=0; i<objects; i++) if((&object[i] != intersection->objectptr) && (DetectObject[object[i].type](&shadowray,&object[i],&shadowintersection,EXACT_INTERSECTION)))
      if(shadowintersection.t != INFINITE_DISTANCE)
      { // arnyek vektor:
        S.X= shadowintersection.point.X - intersection->point.X;
        S.Y= shadowintersection.point.Y - intersection->point.Y;
        S.Z= shadowintersection.point.Z - intersection->point.Z;

        if(DotProductVectors(&L,&L) > DotProductVectors(&S,&S))
        { // i. object blokkolta a pixelt:
          *R*= 0.5;
          *G*= 0.5;
          *B*= 0.5;

          // shadowcache frissitese:
          shadowcache= i;
          break;
        }
      }
    }
  }
  else *R= *G= *B= 0.0;

  // kodkepzes:
  if((sceneflags & FOGGED) && (intersection->t > FOG_DISTANCE_MIN))
  { if(intersection->t < FOG_DISTANCE_MAX)
    { fog_scaler= (FOG_DISTANCE_MAX - intersection->t)/(FOG_DISTANCE_MAX - FOG_DISTANCE_MIN);
      fog_adder= (1.0 - fog_scaler)*255.0;

      *R= fog_scaler**R + fog_adder/2;
      *G= fog_scaler**G + fog_adder/2;
      *B= fog_scaler**B + fog_adder;
    }
    else { *R= 128; *G= 128; *B= 255.0; }
  }
}

void TraceScene(byte *destptr,CAMERA *camera,OMNI_LIGHTSOURCE *light,dword flags)
{ dword x,y;
  VECTOR V,U,V1,V2,P0,VV1,VV2;
  RAY ray;
  INTERSECTION intersection;
  float R,G,B;

  // V vektor (nezett_pont - nezo_pont vektora normalva):
  V.X= camera->target.X - camera->position.X;
  V.Y= camera->target.Y - camera->position.Y;
  V.Z= camera->target.Z - camera->position.Z;
  NormalizeVector(&V);

  // U a felfele mutato vektor a cameraroll fuggvenyeben (normalt):
  U.X= fsin(camera->roll);
  U.Y= -fcos(camera->roll);
  U.Z= 0;

  // V1/V2 a kepsik meroleges vektorai (V1= U X V, V2= V1 X V):
  CrossProductVectors(&V1,&U,&V);
  CrossProductVectors(&V2,&V1,&V);
  NormalizeVector(&V1);
  NormalizeVector(&V2);

  // V1 es V2 meretezese (0.625-os aspect ratio):
  V1.X*= camera->FOV/X_RESOLUTION; V1.Y*= camera->FOV/X_RESOLUTION; V1.Z*= camera->FOV/X_RESOLUTION;
  V2.X*= camera->FOV/(Y_RESOLUTION/0.625); V2.Y*= camera->FOV/(Y_RESOLUTION/0.625); V2.Z*= camera->FOV/(Y_RESOLUTION/0.625);

  // P0 a kepernyo bal felso pontja (P0= V - (V1*XRES/2) - (V2*YRES/2)):
  P0.X= V.X - (V1.X*X_RESOLUTION/2) - (V2.X*Y_RESOLUTION/2);
  P0.Y= V.Y - (V1.Y*X_RESOLUTION/2) - (V2.Y*Y_RESOLUTION/2);
  P0.Z= V.Z - (V1.Z*X_RESOLUTION/2) - (V2.Z*Y_RESOLUTION/2);

  // sugarak kezdopontja minden pixelre ugyanaz:
  ray.Pstart.X= camera->position.X;
  ray.Pstart.Y= camera->position.Y;
  ray.Pstart.Z= camera->position.Z;

  // V2= (0,0,0):
  VV2.X= VV2.Y= VV2.Z= 0.0;
#ifdef RAYTRACER_LOWRESOLUTION
  for(y=0; y<46; y++)
#elif defined(RAYTRACER_HIGHRESOLUTION)
  for(y=0; y<91; y++)
#else
  for(y=0; y<180; y++)
#endif
  { // V1= (0,0,0):
    VV1.X= VV1.Y= VV1.Z= 0.0;

#ifdef RAYTRACER_LOWRESOLUTION
    for(x=0; x<81; x++)
#elif defined(RAYTRACER_HIGHRESOLUTION)
    for(x=0; x<161; x++)
#else
    for(x=0; x<320; x++)
#endif
    { // (x,y) pixel torlese:
      R= G= B= 0.0;

      // sugar szamitasa:
      intersection.t= INFINITE_DISTANCE;
      if(flags & USE_RAY_PERTURBANCE)
      { // sugarak torzitasa sin/cos fuggvenyekkel:
#ifdef RAYTRACER_LOWRESOLUTION
        ray.D.X= P0.X + VV1.X + VV2.X + fsin(x / 10.0)/10.0;
        ray.D.Y= P0.Y + VV1.Y + VV2.Y + fcos(x / 10.0)/10.0;
#elif defined(RAYTRACER_HIGHRESOLUTION)
        ray.D.X= P0.X + VV1.X + VV2.X + fsin(x / 10.0)/20.0;
        ray.D.Y= P0.Y + VV1.Y + VV2.Y + fcos(x / 10.0)/20.0;
#else
        ray.D.X= P0.X + VV1.X + VV2.X + fsin(x / 10.0)/40.0;
        ray.D.Y= P0.Y + VV1.Y + VV2.Y + fcos(x / 10.0)/40.0;
#endif
      }
      else
      { ray.D.X= P0.X + VV1.X + VV2.X;
        ray.D.Y= P0.Y + VV1.Y + VV2.Y;
      }
      ray.D.Z= P0.Z + VV1.Z + VV2.Z;
      NormalizeVector(&ray.D);

      // sugar kilovese:
      media= 0;
      TraceRay(0,&ray,&intersection,light,&V,&R,&G,&B);

      // trace-lt pixel kirakasa BGRa sorrendben:
      if(B > 255.0) *destptr= 255; else *destptr= (byte)B;
      if(G > 255.0) *(destptr + 1)= 255; else *(destptr + 1)= (byte)G;
      if(R > 255.0) *(destptr + 2)= 255; else *(destptr + 2)= (byte)R;

      // VV1= VV1 + V1:
      VV1.X+= V1.X;
      VV1.Y+= V1.Y;
      VV1.Z+= V1.Z;

      // pixelek atugrasa:
#ifdef RAYTRACER_LOWRESOLUTION
      destptr+= 4*4;
#elif defined(RAYTRACER_HIGHRESOLUTION)
      destptr+= 2*4;
#else
      destptr+= 4;
#endif
    }
    // VV2= VV2 + V2:
    VV2.X+= V2.X;
    VV2.Y+= V2.Y;
    VV2.Z+= V2.Z;

    // sorok atugrasa:
#ifdef RAYTRACER_LOWRESOLUTION
    destptr+= 4*(3*320 - 4);
#elif defined(RAYTRACER_HIGHRESOLUTION)
    destptr+= 4*(320 - 2);
#else
#endif
  }
}